<?php
include_once('../../includes/db.php');

$query = "SELECT 
    id, 
    name, 
    price, 
    print_price, 
    description, 
    sizes, 
    front_image, 
    back_image
FROM products 
ORDER BY id DESC";

$products = fetchAll($query);

// Attach only front and back images into an array if available
foreach ($products as &$product) {
    $images = [];

    foreach (['front_image', 'back_image'] as $key) {
        if (!empty($product[$key])) {
            $images[] = $product[$key];
        }
    }

    if (!empty($images)) {
        $product['images'] = $images;
    }
}

echo json_encode(['status' => true, 'data' => $products]);
