<?php
include_once('../../includes/db.php');
header('Content-Type: application/json');

// Get input from JSON body
$input = file_get_contents("php://input");
$data = json_decode($input, true);

// Support fallback to GET if JSON body is not present
$order_id = $data['order_id'] ?? $_GET['order_id'] ?? null;
$status   = $data['status'] ?? $_GET['status'] ?? null;

// Validate input
if (!$order_id || !$status) {
    echo json_encode([
        "status" => false,
        "message" => "Order ID and status are required"
    ]);
    exit;
}

// Update order in the database
try {
    executeQuery("UPDATE orders SET status = ? WHERE id = ?", [$status, $order_id]);

    echo json_encode([
        "status" => true,
        "message" => "Status updated"
    ]);
} catch (Exception $e) {
    echo json_encode([
        "status" => false,
        "message" => "Database error: " . $e->getMessage()
    ]);
}
?>
