<?php
include_once('../../includes/db.php');
header('Content-Type: application/json');

$user_id = $_GET['user_id'] ?? null;

if (!$user_id) {
    echo json_encode(["status" => false, "message" => "User ID is required"]);
    exit;
}

$orders = fetchAll("SELECT * FROM orders WHERE user_id = ? ORDER BY id DESC", [$user_id]);

// 🔁 Convert "pending" to "placed"
foreach ($orders as &$order) {
    if (strtolower($order['status']) === 'pending') {
        $order['status'] = 'placed';
    }
}

echo json_encode(["status" => true, "orders" => $orders]);
?>
