<?php
include_once('../../includes/db.php');
header('Content-Type: application/json');
ini_set('display_errors', 1);
error_reporting(E_ALL);

$order_id = $_GET['order_id'] ?? null;

if (!$order_id) {
    echo json_encode([
        "status" => false,
        "message" => "Order ID is required"
    ]);
    exit;
}

$order = fetchOne("SELECT status, created_at FROM orders WHERE id = ?", [$order_id]);

if ($order) {
    $status = strtolower($order['status']);

    // 🎯 Convert 'pending' to 'placed'
    if ($status === "pending") {
        $status = "placed";
    }

    echo json_encode([
        "status" => true,
        "data" => [
            "status" => $status,
            "created_at" => $order['created_at']
        ]
    ]);
} else {
    echo json_encode([
        "status" => false,
        "message" => "Order not found"
    ]);
}
?>
