<?php
// printshop/api/get_user_by_id.php

ini_set('display_errors', 1);
error_reporting(E_ALL);

include_once('../../includes/db.php');
header("Content-Type: application/json");

// ✅ Accept user_id from POST or GET (browser test)
$user_id = $_POST['user_id'] ?? $_GET['user_id'] ?? '';

if (empty($user_id)) {
    echo json_encode(["status" => false, "message" => "Missing user_id"]);
    exit;
}

$user_id = mysqli_real_escape_string($conn, $user_id);
$user = fetchOne("SELECT * FROM users WHERE id = '$user_id'");

if ($user) {
    echo json_encode([
        "status" => true,
        "user" => [
            "id" => $user['id'],
            "name" => $user['name'],
            "email" => $user['email'],
            "phone" => $user['phone'],
            "address" => $user['address'] ?? '',
            "location" => $user['location'] ?? ''
        ]
    ]);
} else {
    echo json_encode(["status" => false, "message" => "User not found"]);
}
