<?php
session_start();
include_once('../includes/db.php');
include_once('../functions/notification_functions.php');

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.php");
    exit;
}

$success = "";
$error = "";

$users = fetchAll("SELECT id, name FROM users WHERE onesignal_id IS NOT NULL ORDER BY name ASC");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = sanitize($_POST['title']);
    $message = sanitize($_POST['message']);
    $userId = $_POST['user_id'];

    if (!empty($title) && !empty($message) && !empty($userId)) {
        execute("INSERT INTO notifications (user_id, title, message) VALUES (?, ?, ?)", [$userId, $title, $message]);
        $response = sendPushNotification($userId, $title, $message);
        $success = "✅ Notification sent successfully!";
    } else {
        $error = "❌ Please fill in all fields.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Send Notification - PrintShop Admin</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
  <style>
    body {
      background-color: #f1f5f9;
      font-family: 'Segoe UI', sans-serif;
    }

    .main-content {
      margin-left: 250px;
      padding: 30px;
    }

    .card {
      border-radius: 1rem;
      box-shadow: 0 2px 12px rgba(0,0,0,0.06);
      border: none;
    }

    .card-header {
      background-color: #000 !important;
      color: white;
      font-weight: 600;
      font-size: 18px;
      display: flex;
      align-items: center;
      gap: 10px;
    }

    .form-label {
      font-weight: 500;
    }

    .btn {
      border-radius: 8px;
    }

    select.form-select {
      border-radius: 10px;
    }

    textarea.form-control, input.form-control {
      border-radius: 10px;
    }
  </style>
</head>
<body>

<div class="d-flex">
  <?php include('admin_sidebar.php'); ?>

  <div class="main-content flex-grow-1">
    <div class="card shadow-sm border-0">
      <div class="card-header rounded-top">
        <i class="fas fa-paper-plane"></i> Send Notification
      </div>
      <div class="card-body">
        <?php if (!empty($success)): ?>
          <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
        <?php elseif (!empty($error)): ?>
          <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>

        <form method="POST">
          <div class="mb-3">
            <label class="form-label">Title</label>
            <input name="title" class="form-control" placeholder="Enter title" required>
          </div>

          <div class="mb-3">
            <label class="form-label">Message</label>
            <textarea name="message" class="form-control" rows="4" placeholder="Enter message body" required></textarea>
          </div>

          <div class="mb-4">
            <label class="form-label">Select User</label>
            <select name="user_id" class="form-select" required>
              <option value="" disabled selected>Choose a user</option>
              <?php foreach ($users as $user): ?>
                <option value="<?= $user['id'] ?>"><?= htmlspecialchars($user['name']) ?> (ID: <?= $user['id'] ?>)</option>
              <?php endforeach; ?>
            </select>
          </div>

          <div class="text-end">
            <button type="submit" class="btn btn-success px-4"><i class="fas fa-paper-plane me-1"></i>Send Notification</button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

</body>
</html>
