<?php
session_start();
include_once('../includes/db.php');

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.php");
    exit;
}

$products = fetchAll("SELECT products.*, categories.name as category_name FROM products LEFT JOIN categories ON products.category_id = categories.id");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Manage Products - PrintShop Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f1f5f9;
        }

        .main-content {
            margin-left: 250px;
            padding: 30px;
        }

        .card {
            border-radius: 1rem;
        }

        .table td, .table th {
            vertical-align: middle;
        }

        .badge {
            font-size: 13px;
        }

        .btn-success {
            font-size: 14px;
        }
    </style>
</head>
<body>

<div class="d-flex">
    <!-- Sidebar -->
    <?php include('admin_sidebar.php'); ?>

    <!-- Main Content -->
    <div class="main-content flex-grow-1">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h4 class="mb-0">🛍 Product List</h4>
            <a href="add_product.php" class="btn btn-success">+ Add Product</a>
        </div>

        <div class="card shadow-sm border-0">
            <div class="card-header bg-dark text-white rounded-top">
                <h6 class="mb-0">All Products</h6>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover align-middle mb-0 bg-white">
                        <thead class="table-light">
                            <tr>
                                <th>Name</th>
                                <th>Price</th>
                                <th>Category</th>
                                <th>Discount (%)</th>
                                <th>New?</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($products as $p): ?>
                                <tr>
                                    <td><?= htmlspecialchars($p['name']) ?></td>
                                    <td>$<?= number_format($p['price'], 2) ?></td>
                                    <td><?= htmlspecialchars($p['category_name'] ?? '—') ?></td>
                                    <td><?= floatval($p['discount']) ?>%</td>
                                    <td>
                                        <span class="badge bg-<?= $p['is_new'] ? 'success' : 'secondary' ?>">
                                            <?= $p['is_new'] ? 'Yes' : 'No' ?>
                                        </span>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                            <?php if (empty($products)): ?>
                                <tr><td colspan="5" class="text-center">No products found.</td></tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

</body>
</html>
