<?php
session_start();
include_once('../includes/db.php');

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.php");
    exit;
}

$orders = fetchAll("
    SELECT o.*, u.name AS user_name, u.phone 
    FROM orders o 
    JOIN users u ON o.user_id = u.id 
    ORDER BY o.created_at DESC
");

$drivers = fetchAll("SELECT id, name FROM drivers");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Manage Orders - PrintShop Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f1f5f9;
        }
        .main-content {
            margin-left: 250px;
            padding: 30px;
        }
        .card {
            border-radius: 1rem;
        }
        .table td, .table th {
            vertical-align: middle;
        }
        .badge {
            text-transform: capitalize;
        }
        .form-select-sm {
            min-width: 120px;
        }
        .text-muted small {
            font-size: 85%;
        }
    </style>
</head>
<body>

<div class="d-flex">
    <?php include('admin_sidebar.php'); ?>

    <div class="main-content flex-grow-1">
        <div class="card shadow-sm border-0">
            <div class="card-header bg-dark text-white rounded-top">
                <h5 class="mb-0">📦 Manage Orders</h5>
            </div>
            <div class="card-body">
                <?php if (isset($_GET['success'])): ?>
                    <div class="alert alert-success"><?= htmlspecialchars($_GET['success']) ?></div>
                <?php elseif (isset($_GET['error'])): ?>
                    <div class="alert alert-danger"><?= htmlspecialchars($_GET['error']) ?></div>
                <?php endif; ?>

                <div class="table-responsive">
                    <table class="table table-bordered table-hover align-middle bg-white mt-2">
                        <thead class="table-light">
                            <tr>
                                <th>Order ID</th>
                                <th>User</th>
                                <th>Phone</th>
                                <th>Shipping Address</th>
                                <th>Status</th>
                                <th>Created</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($orders as $order): ?>
                                <tr>
                                    <td>#<?= $order['id'] ?></td>
                                    <td><?= htmlspecialchars($order['user_name']) ?></td>
                                    <td><?= htmlspecialchars($order['phone']) ?></td>
                                    <td>
                                        <?= nl2br(htmlspecialchars($order['address'])) ?><br>
                                        <small class="text-muted">📍 <?= htmlspecialchars($order['location']) ?></small>
                                    </td>
                                    <td>
                                        <span class="badge text-bg-<?=
                                            $order['status'] === 'placed' ? 'warning' :
                                            ($order['status'] === 'shipped' ? 'info' : 'success')
                                        ?>">
                                            <?= ucfirst($order['status']) ?>
                                        </span>
                                    </td>
                                    <td><?= date('d M Y - h:i A', strtotime($order['created_at'])) ?></td>
                                    <td>
                                        <!-- Status Update Form -->
                                        <form method="POST" action="update_order_status.php" class="d-flex align-items-center mb-2">
                                            <input type="hidden" name="order_id" value="<?= $order['id'] ?>">
                                            <select name="new_status" class="form-select form-select-sm me-2">
                                                <option value="placed" <?= $order['status'] === 'placed' ? 'selected' : '' ?>>Placed</option>
                                                <option value="shipped" <?= $order['status'] === 'shipped' ? 'selected' : '' ?>>Shipped</option>
                                                <option value="delivered" <?= $order['status'] === 'delivered' ? 'selected' : '' ?>>Delivered</option>
                                            </select>
                                            <button type="submit" class="btn btn-sm btn-primary">Update</button>
                                        </form>

                                        <!-- Driver Assignment Form -->
                                        <form method="POST" action="assign_driver.php" class="d-flex align-items-center">
                                            <input type="hidden" name="order_id" value="<?= $order['id'] ?>">
                                            <select name="driver_id" class="form-select form-select-sm me-2" required>
                                                <option value="">-- Select Driver --</option>
                                                <?php foreach ($drivers as $driver): ?>
                                                    <option value="<?= $driver['id'] ?>" <?= $order['driver_id'] == $driver['id'] ? 'selected' : '' ?>>
                                                        <?= htmlspecialchars($driver['name']) ?>
                                                    </option>
                                                <?php endforeach; ?>
                                            </select>
                                            <button type="submit" class="btn btn-sm btn-outline-secondary">Assign</button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                            <?php if (empty($orders)): ?>
                                <tr>
                                    <td colspan="7" class="text-center">No orders found.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

            </div>
        </div>
    </div>
</div>

</body>
</html>
