<?php
session_start();
include_once('../includes/db.php');

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.php");
    exit;
}

$onboarding_data = fetchAll("SELECT * FROM onboarding ORDER BY sort_order ASC");

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_FILES['image'])) {
        $image_name = $_FILES['image']['name'];
        $image_tmp = $_FILES['image']['tmp_name'];
        $image_error = $_FILES['image']['error'];
        $image_size = $_FILES['image']['size'];

        if ($image_error === 0) {
            $image_ext = pathinfo($image_name, PATHINFO_EXTENSION);
            $allowed_ext = ['jpg', 'jpeg', 'png', 'gif'];

            if (in_array(strtolower($image_ext), $allowed_ext)) {
                $new_image_name = uniqid('onboarding_', true) . '.' . $image_ext;
                $upload_dir = '../uploads/';
                if (!is_dir($upload_dir)) {
                    mkdir($upload_dir, 0755, true);
                }
                $image_path = $upload_dir . $new_image_name;

                if (move_uploaded_file($image_tmp, $image_path)) {
                    $sort_order = count($onboarding_data) + 1;
                    execute("INSERT INTO onboarding (image_url, sort_order) VALUES (?, ?)", [$image_path, $sort_order]);
                    header("Location: manage_onboarding.php");
                    exit;
                } else {
                    $error = "Error uploading the image.";
                }
            } else {
                $error = "Invalid file type.";
            }
        } else {
            $error = "Error uploading file.";
        }
    }

    if (isset($_POST['delete_onboarding'])) {
        $id = $_POST['id'];
        $result = fetchOne("SELECT image_url FROM onboarding WHERE id = ?", [$id]);
        $image_path = $result['image_url'];

        if (file_exists($image_path)) {
            unlink($image_path);
        }

        execute("DELETE FROM onboarding WHERE id = ?", [$id]);
        header("Location: manage_onboarding.php");
        exit;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Manage Onboarding - PrintShop Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f1f5f9;
            font-family: 'Segoe UI', sans-serif;
        }

        .main-content {
            margin-left: 250px;
            padding: 30px;
        }

        .card {
            border-radius: 1rem;
            border: none;
            box-shadow: 0 2px 12px rgba(0,0,0,0.06);
        }

        .card-header {
            background-color: #000;
            color: #fff;
            font-size: 18px;
            font-weight: 600;
            padding: 16px 24px;
            border-top-left-radius: 1rem;
            border-top-right-radius: 1rem;
        }

        .form-label {
            font-weight: 500;
            color: #1e293b;
        }

        .table img {
            max-height: 100px;
            object-fit: cover;
            border-radius: 0.5rem;
            border: 1px solid #e2e8f0;
        }

        .btn {
            border-radius: 8px;
        }

        .btn-sm {
            font-size: 14px;
        }

        .alert {
            font-size: 15px;
        }
    </style>
</head>
<body>

<div class="d-flex">
    <!-- Sidebar -->
    <?php include('admin_sidebar.php'); ?>

    <!-- Main Content -->
    <div class="main-content flex-grow-1">
        <!-- Upload Onboarding Image -->
        <div class="card shadow-sm border-0 mb-4">
            <div class="card-header">
                🖼 Upload New Onboarding Image
            </div>
            <div class="card-body">
                <?php if (isset($error)): ?>
                    <div class="alert alert-danger"><?= $error ?></div>
                <?php endif; ?>

                <form method="POST" enctype="multipart/form-data">
                    <div class="mb-3">
                        <label for="image" class="form-label">Select Image</label>
                        <input type="file" class="form-control" id="image" name="image" accept="image/*" required>
                    </div>
                    <button type="submit" class="btn btn-success" name="add_onboarding">Upload Image</button>
                </form>
            </div>
        </div>

        <!-- Existing Slides -->
        <div class="card shadow-sm border-0">
            <div class="card-header bg-dark text-white">
                🖼 Current Onboarding Slides
            </div>
            <div class="card-body">
                <?php if (empty($onboarding_data)): ?>
                    <div class="alert alert-warning text-center">No onboarding images found.</div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered bg-white">
                            <thead class="table-light">
                                <tr>
                                    <th>Preview</th>
                                    <th style="width: 150px;">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($onboarding_data as $onboarding): ?>
                                    <tr>
                                        <td>
                                            <img src="<?= htmlspecialchars($onboarding['image_url']) ?>" alt="Onboarding Slide">
                                        </td>
                                        <td>
                                            <form method="POST" onsubmit="return confirm('Are you sure you want to delete this slide?')">
                                                <input type="hidden" name="id" value="<?= $onboarding['id'] ?>">
                                                <button type="submit" name="delete_onboarding" class="btn btn-danger btn-sm w-100">Delete</button>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

</body>
</html>
