<?php
session_start();
include_once('../includes/db.php');

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.php");
    exit;
}

$newsList = fetchAll("SELECT * FROM news ORDER BY id DESC");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = sanitize($_POST['title']);
    $content = sanitize($_POST['content']);
    $query = "INSERT INTO news (title, content) VALUES ('$title', '$content')";
    if (executeQuery($query)) {
        $success = "✅ News item added successfully.";
        $newsList = fetchAll("SELECT * FROM news ORDER BY id DESC");
    } else {
        $error = "❌ Failed to add news item.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Manage News - PrintShop Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f1f5f9;
            font-family: 'Segoe UI', sans-serif;
        }

        .main-content {
            margin-left: 250px;
            padding: 30px;
        }

        .card {
            border-radius: 1rem;
            border: none;
            box-shadow: 0 2px 12px rgba(0, 0, 0, 0.06);
        }

        .card-header {
            background-color: #000;
            color: #fff;
            font-size: 18px;
            font-weight: 600;
            padding: 16px 24px;
            border-top-left-radius: 1rem;
            border-top-right-radius: 1rem;
        }

        .news-title {
            font-weight: 600;
            font-size: 16px;
        }

        .news-content {
            font-size: 14px;
            color: #555;
            margin-top: 6px;
        }

        .list-group-item {
            background: #fff;
            border: 1px solid #e2e8f0;
            border-radius: 0.5rem;
            margin-bottom: 10px;
            padding: 15px;
        }

        .form-label {
            font-weight: 500;
            color: #1e293b;
        }

        .form-control, .btn {
            border-radius: 8px;
        }
    </style>
</head>
<body>

<div class="d-flex">
    <!-- Sidebar -->
    <?php include('admin_sidebar.php'); ?>

    <!-- Main Content -->
    <div class="main-content flex-grow-1">
        <div class="card shadow-sm border-0">
            <div class="card-header">
                🗞 Add News
            </div>
            <div class="card-body">
                <?php if (isset($success)): ?>
                    <div class="alert alert-success"><?= $success ?></div>
                <?php elseif (isset($error)): ?>
                    <div class="alert alert-danger"><?= $error ?></div>
                <?php endif; ?>

                <form method="post" class="mb-4">
                    <div class="mb-3">
                        <label class="form-label">Title</label>
                        <input name="title" class="form-control" placeholder="News title" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Content</label>
                        <textarea name="content" class="form-control" rows="4" placeholder="News content" required></textarea>
                    </div>

                    <button type="submit" class="btn btn-success">Add News</button>
                </form>

                <h5 class="mb-3">📰 Recent News</h5>
                <ul class="list-group">
                    <?php foreach ($newsList as $news): ?>
                        <li class="list-group-item">
                            <div class="news-title"><?= htmlspecialchars($news['title']) ?></div>
                            <div class="news-content"><?= nl2br(htmlspecialchars($news['content'])) ?></div>
                        </li>
                    <?php endforeach; ?>
                    <?php if (empty($newsList)): ?>
                        <li class="list-group-item text-muted">No news items found.</li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </div>
</div>

</body>
</html>
