<?php
session_start();
include_once('../includes/db.php');

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.php");
    exit;
}

$contacts = fetchAll("SELECT * FROM contact_messages ORDER BY created_at DESC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Manage Contact Messages - PrintShop Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f1f5f9;
        }

        .main-content {
            margin-left: 250px;
            padding: 30px;
        }

        .table td, .table th {
            vertical-align: middle;
        }

        .card {
            border-radius: 1rem;
        }
    </style>
</head>
<body>

<div class="d-flex">
    <!-- Sidebar -->
    <?php include('admin_sidebar.php'); ?>

    <!-- Main Content -->
    <div class="main-content flex-grow-1">
        <div class="card shadow-sm border-0">
            <div class="card-header bg-dark text-white rounded-top">
                <h4 class="mb-0">📬 Contact Messages</h4>
            </div>
            <div class="card-body">
                <?php if (empty($contacts)): ?>
                    <div class="alert alert-warning">No contact messages found.</div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover bg-white">
                            <thead class="table-dark">
                                <tr>
                                    <th>#</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Message</th>
                                    <th>Submitted At</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($contacts as $index => $msg): ?>
                                    <tr>
                                        <td><?= $index + 1 ?></td>
                                        <td><?= htmlspecialchars($msg['name']) ?></td>
                                        <td><?= htmlspecialchars($msg['email']) ?></td>
                                        <td><?= nl2br(htmlspecialchars($msg['message'])) ?></td>
                                        <td><?= date('d M Y, h:i A', strtotime($msg['created_at'])) ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

</body>
</html>
