<?php
session_start();
include_once('../includes/db.php');

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.php");
    exit;
}

$success = $error = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['banner_image'])) {
    $targetDir = '../uploads/banner_images/';
    if (!is_dir($targetDir)) {
        mkdir($targetDir, 0755, true);
    }

    $fileName = time() . '_' . basename($_FILES["banner_image"]["name"]);
    $targetFile = $targetDir . $fileName;

    $fileType = strtolower(pathinfo($targetFile, PATHINFO_EXTENSION));
    $allowedTypes = ['jpg', 'jpeg', 'png', 'gif'];

    if (!in_array($fileType, $allowedTypes)) {
        $error = "Only JPG, JPEG, PNG, and GIF files are allowed.";
    } elseif (move_uploaded_file($_FILES["banner_image"]["tmp_name"], $targetFile)) {
        $relativePath = 'uploads/banner_images/' . $fileName;
        $stmt = $conn->prepare("INSERT INTO banners (image) VALUES (?)");
        $stmt->bind_param("s", $relativePath);
        if ($stmt->execute()) {
            $success = "Banner uploaded successfully.";
        } else {
            $error = "Failed to save banner in database.";
        }
        $stmt->close();
    } else {
        $error = "Failed to upload banner image.";
    }
}

$banners = [];
$result = $conn->query("SELECT * FROM banners ORDER BY id DESC");
if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $banners[] = $row;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Manage Banners - PrintShop Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f1f5f9;
            font-family: 'Segoe UI', sans-serif;
        }

        .main-content {
            margin-left: 250px;
            padding: 40px;
        }

        .card {
            border-radius: 1rem;
            border: none;
            box-shadow: 0 2px 12px rgba(0, 0, 0, 0.06);
        }

        .card-header {
            background-color: #000;
            color: #fff;
            font-size: 18px;
            font-weight: 600;
            padding: 16px 24px;
            border-top-left-radius: 1rem;
            border-top-right-radius: 1rem;
        }

        .card img {
            height: 150px;
            object-fit: cover;
            border-radius: 0.5rem;
        }

        .form-label {
            font-weight: 500;
            color: #1e293b;
        }

        .alert {
            font-size: 15px;
        }

        .banner-grid .card {
            overflow: hidden;
        }

        .btn {
            border-radius: 8px;
        }
    </style>
</head>
<body>

<div class="d-flex">

    <!-- Sidebar -->
    <?php include('admin_sidebar.php'); ?>

    <div class="main-content">
        <div class="card shadow-sm mb-4">
            <div class="card-header">
                🖼 Upload New Banner
            </div>
            <div class="card-body">
                <?php if ($success): ?>
                    <div class="alert alert-success"><?= $success ?></div>
                <?php endif; ?>
                <?php if ($error): ?>
                    <div class="alert alert-danger"><?= $error ?></div>
                <?php endif; ?>

                <form method="POST" enctype="multipart/form-data">
                    <div class="mb-3">
                        <label for="banner_image" class="form-label">Select Banner Image</label>
                        <input class="form-control" type="file" name="banner_image" required>
                    </div>
                    <button type="submit" class="btn btn-success px-4">Upload</button>
                </form>
            </div>
        </div>

        <h4 class="mb-3">🖼 Uploaded Banners</h4>
        <div class="row banner-grid">
            <?php foreach ($banners as $banner): ?>
                <div class="col-md-3 col-sm-4 col-6 mb-4">
                    <div class="card shadow-sm">
                        <img src="../<?= htmlspecialchars($banner['image']) ?>" alt="Banner Image" class="w-100">
                    </div>
                </div>
            <?php endforeach; ?>
            <?php if (empty($banners)): ?>
                <div class="text-muted">No banners uploaded yet.</div>
            <?php endif; ?>
        </div>
    </div>
</div>

</body>
</html>
