<?php
session_start();
include_once('../includes/db.php');

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.php");
    exit;
}

$total_users = fetchOne("SELECT COUNT(*) as total FROM users")['total'];
$total_products = fetchOne("SELECT COUNT(*) as total FROM products")['total'];
$total_orders = fetchOne("SELECT COUNT(*) as total FROM orders")['total'];
$recent_orders = fetchAll("SELECT orders.id, users.name, orders.payment_type, orders.status, orders.created_at 
                            FROM orders JOIN users ON orders.user_id = users.id
                            ORDER BY orders.created_at DESC LIMIT 10");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin Dashboard - PrintShop</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f1f5f9;
            font-family: 'Segoe UI', sans-serif;
        }

        .main-content {
            margin-left: 250px;
            padding: 30px;
        }

        .dashboard-title {
            font-size: 28px;
            font-weight: 600;
            color: #1e293b;
            margin-bottom: 30px;
        }

        .stat-card {
            border: none;
            border-radius: 12px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            transition: 0.3s;
        }

        .stat-card:hover {
            transform: translateY(-5px);
        }

        .stat-card .icon {
            font-size: 28px;
            background: #3b82f6;
            color: #fff;
            padding: 12px;
            border-radius: 10px;
            display: inline-block;
        }

        .stat-card h6 {
            margin-top: 15px;
            font-size: 16px;
            color: #64748b;
        }

        .stat-card p {
            font-size: 26px;
            font-weight: bold;
            color: #1e3a8a;
            margin-bottom: 0;
        }

        .orders-table .table th {
            background-color: #f1f5f9;
            color: #1e293b;
        }

        .badge {
            padding: 6px 10px;
            font-size: 13px;
            text-transform: capitalize;
        }

        .badge-placed {
            background: #facc15;
            color: #92400e;
        }

        .badge-shipped {
            background: #38bdf8;
            color: #1e3a8a;
        }

        .badge-delivered {
            background: #34d399;
            color: #064e3b;
        }

        .table td, .table th {
            vertical-align: middle;
        }
    </style>
</head>
<body>

<div class="d-flex">
    <?php include('admin_sidebar.php'); ?>

    <div class="main-content flex-grow-1">
        <div class="dashboard-title">👋 Welcome back, Admin</div>

        <!-- Stats -->
        <div class="row g-4 mb-5">
            <div class="col-md-4">
                <div class="card stat-card p-4">
                    <div class="icon bg-primary"><i class="fas fa-users"></i></div>
                    <h6>Total Users</h6>
                    <p><?= $total_users ?></p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card stat-card p-4">
                    <div class="icon bg-success"><i class="fas fa-box"></i></div>
                    <h6>Total Products</h6>
                    <p><?= $total_products ?></p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card stat-card p-4">
                    <div class="icon bg-info"><i class="fas fa-clipboard-list"></i></div>
                    <h6>Total Orders</h6>
                    <p><?= $total_orders ?></p>
                </div>
            </div>
        </div>

        <!-- Orders Table -->
        <div class="orders-table">
            <h5 class="mb-3"><i class="fas fa-clock me-1 text-muted"></i> Recent Orders</h5>
            <div class="card shadow-sm border-0">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead>
                            <tr>
                                <th>#Order</th>
                                <th>Customer</th>
                                <th>Payment</th>
                                <th>Status</th>
                                <th>Date</th>
                                <th>Invoice</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($recent_orders as $order): ?>
                                <tr>
                                    <td>#<?= $order['id'] ?></td>
                                    <td><?= htmlspecialchars($order['name']) ?></td>
                                    <td><?= htmlspecialchars($order['payment_type']) ?></td>
                                    <td>
                                        <span class="badge 
                                            <?= $order['status'] === 'placed' ? 'badge-placed' : 
                                                ($order['status'] === 'shipped' ? 'badge-shipped' : 'badge-delivered') ?>">
                                            <?= htmlspecialchars($order['status']) ?>
                                        </span>
                                    </td>
                                    <td><?= date('d M Y - h:i A', strtotime($order['created_at'])) ?></td>
                                    <td>
                                        <button class="btn btn-sm btn-outline-secondary me-1" onclick="viewInvoice(<?= $order['id'] ?>)">
                                            View
                                        </button>
                                        <button class="btn btn-sm btn-outline-primary" onclick="downloadInvoice(<?= $order['id'] ?>)">
                                            Download
                                        </button>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                            <?php if (empty($recent_orders)): ?>
                                <tr><td colspan="6" class="text-center">No recent orders found.</td></tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div>
</div>

<script>
function viewInvoice(orderId) {
    window.open(`../invoices/invoice_${orderId}.pdf`, '_blank');
}
function downloadInvoice(orderId) {
    window.location.href = `download_invoice.php?order_id=${orderId}`;
}
</script>

</body>
</html>
