<?php
session_start();
include_once('../includes/db.php');

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: admin_login.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $order_id = intval($_POST['order_id']);
    $driver_id = intval($_POST['driver_id']);

    if (!$order_id || !$driver_id) {
        header("Location: manage_orders.php?error=Missing order or driver.");
        exit;
    }

    $stmt = $conn->prepare("UPDATE orders SET driver_id = ? WHERE id = ?");
    $stmt->bind_param("ii", $driver_id, $order_id);

    if ($stmt->execute()) {
        $stmt->close();
        header("Location: manage_orders.php?success=Driver assigned successfully.");
    } else {
        $stmt->close();
        header("Location: manage_orders.php?error=Failed to assign driver.");
    }
    exit;
} else {
    header("Location: manage_orders.php?error=Invalid request.");
    exit;
}
