<?php
$current = basename($_SERVER['PHP_SELF']);
?>

<!-- Font Awesome CDN -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">

<style>
.sidebar {
    width: 250px;
    height: 100vh;
    background-color: #f1f5f9;
    color: #1e293b;
    font-family: 'Segoe UI', sans-serif;
    padding: 0;
    position: fixed;
    top: 0;
    left: 0;
    overflow-y: auto;
    border-right: 1px solid #e2e8f0;
    display: flex;
    flex-direction: column;
    box-shadow: 2px 0 6px rgba(0, 0, 0, 0.04);
    z-index: 1000;
}

.sidebar-header {
    height: 64px;
    background: #3b82f6;
    color: #ffffff;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 18px;
    font-weight: 600;
    letter-spacing: 0.5px;
    border-bottom: 1px solid #dbeafe;
}

.sidebar nav {
    flex: 1;
    padding: 15px 0;
}

.sidebar .accordion-section {
    padding: 0;
}

.sidebar .accordion-toggle {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 12px 20px;
    cursor: pointer;
    font-weight: 500;
    font-size: 15px;
    color: #334155;
    background: none;
    border: none;
    width: 100%;
    outline: none;
    transition: background 0.2s;
}

.sidebar .accordion-toggle:hover {
    background-color: #e2e8f0;
}

.sidebar .accordion-toggle i.chevron {
    transition: transform 0.3s ease;
}

.sidebar .accordion-toggle.active i.chevron {
    transform: rotate(180deg);
}

.sidebar .accordion-content {
    display: none;
    flex-direction: column;
}

.sidebar .accordion-content a {
    padding-left: 40px;
}

.sidebar a,
.sidebar .accordion-content a {
    display: flex;
    align-items: center;
    gap: 10px;
    color: #334155;
    padding: 12px 20px;
    text-decoration: none;
    font-size: 15px;
    border-left: 4px solid transparent;
    transition: background 0.2s, border 0.2s, color 0.2s;
}

.sidebar a i,
.sidebar .accordion-content a i {
    width: 18px;
    text-align: center;
}

.sidebar a:hover,
.sidebar .accordion-content a:hover {
    background-color: #f1f5f9;
    border-left: 4px solid #3b82f6;
    color: #1e3a8a;
    font-weight: 500;
}

.sidebar a.active {
    background-color: #e0f2fe;
    border-left: 4px solid #3b82f6;
    color: #1e3a8a;
    font-weight: 600;
}

.sidebar .logout {
    margin-top: auto;
    background: #fef2f2;
    color: #b91c1c !important;
    font-weight: 500;
}
</style>

<div class="sidebar">
    <div class="sidebar-header"><i class="fas fa-box-open me-2"></i> PrintShop</div>
    <nav>

        <a href="dashboard.php" class="<?= $current === 'dashboard.php' ? 'active' : '' ?>">
            <i class="fas fa-house"></i> Dashboard
        </a>

        <div class="accordion-section">
            <button class="accordion-toggle">
                <span><i class="fas fa-boxes-stacked"></i> Catalog</span>
                <i class="fas fa-chevron-down chevron"></i>
            </button>
            <div class="accordion-content">
                <a href="manage_categories.php" class="<?= $current === 'manage_categories.php' ? 'active' : '' ?>">
                    <i class="fas fa-layer-group"></i> Categories
                </a>
                <a href="manage_products.php" class="<?= $current === 'manage_products.php' ? 'active' : '' ?>">
                    <i class="fas fa-cube"></i> Products
                </a>
                <a href="add_product.php" class="<?= $current === 'add_product.php' ? 'active' : '' ?>">
                    <i class="fas fa-plus-circle"></i> Add Product
                </a>
            </div>
        </div>

        <div class="accordion-section">
            <button class="accordion-toggle">
                <span><i class="fas fa-bullhorn"></i> Marketing</span>
                <i class="fas fa-chevron-down chevron"></i>
            </button>
            <div class="accordion-content">
                <a href="manage_offers.php" class="<?= $current === 'manage_offers.php' ? 'active' : '' ?>">
                    <i class="fas fa-gift"></i> Offers
                </a>
                <a href="manage_news.php" class="<?= $current === 'manage_news.php' ? 'active' : '' ?>">
                    <i class="fas fa-newspaper"></i> News
                </a>
                <a href="manage_banners.php" class="<?= $current === 'manage_banners.php' ? 'active' : '' ?>">
                    <i class="fas fa-image"></i> Banners
                </a>
                <a href="manage_onboarding.php" class="<?= $current === 'manage_onboarding.php' ? 'active' : '' ?>">
                    <i class="fas fa-rocket"></i> Onboarding
                </a>
            </div>
        </div>

        <div class="accordion-section">
            <button class="accordion-toggle">
                <span><i class="fas fa-bell"></i> Notifications</span>
                <i class="fas fa-chevron-down chevron"></i>
            </button>
            <div class="accordion-content">
                <a href="send_notification.php" class="<?= $current === 'send_notification.php' ? 'active' : '' ?>">
                    <i class="fas fa-paper-plane"></i> Send
                </a>
                <a href="manage_notifications.php" class="<?= $current === 'manage_notifications.php' ? 'active' : '' ?>">
                    <i class="fas fa-history"></i> History
                </a>
            </div>
        </div>

        <div class="accordion-section">
            <button class="accordion-toggle">
                <span><i class="fas fa-tools"></i> Management</span>
                <i class="fas fa-chevron-down chevron"></i>
            </button>
            <div class="accordion-content">
                <a href="manage_users.php" class="<?= $current === 'manage_users.php' ? 'active' : '' ?>">
                    <i class="fas fa-users"></i> Users
                </a>
                <a href="manage_orders.php" class="<?= $current === 'manage_orders.php' ? 'active' : '' ?>">
                    <i class="fas fa-box"></i> Orders
                </a>
                <a href="manage_contacts.php" class="<?= $current === 'manage_contacts.php' ? 'active' : '' ?>">
                    <i class="fas fa-envelope"></i> Messages
                </a>
                <a href="manage_terms.php" class="<?= $current === 'manage_terms.php' ? 'active' : '' ?>">
                    <i class="fas fa-file-contract"></i> Terms
                </a>
            </div>
        </div>

    </nav>

    <a href="logout.php" class="logout d-flex align-items-center gap-2 p-3">
        <i class="fas fa-sign-out-alt"></i> Logout
    </a>
</div>

<script>
document.querySelectorAll('.accordion-toggle').forEach(toggle => {
    toggle.addEventListener('click', () => {
        const content = toggle.nextElementSibling;
        const isOpen = content.style.display === 'flex';
        content.style.display = isOpen ? 'none' : 'flex';
        toggle.classList.toggle('active', !isOpen);
    });
});

// Auto-expand active section
document.querySelectorAll('.accordion-content a.active').forEach(link => {
    const content = link.closest('.accordion-content');
    const toggle = content.previousElementSibling;
    if (content) {
        content.style.display = 'flex';
        toggle.classList.add('active');
    }
});
</script>
