<?php
session_start();
include_once('../../includes/db.php'); // ✅ Correct path now

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name']);
    $new_password = trim($_POST['new_password']);

    $stmt = $conn->prepare("SELECT id FROM drivers WHERE name = ?");
    $stmt->bind_param("s", $name);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows === 1) {
        $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
        $update_stmt = $conn->prepare("UPDATE drivers SET password = ? WHERE name = ?");
        $update_stmt->bind_param("ss", $hashed_password, $name);
        if ($update_stmt->execute()) {
            $success = "Password updated successfully.";
        } else {
            $error = "Update failed.";
        }
        $update_stmt->close();
    } else {
        $error = "Driver not found.";
    }
    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reset Password</title>
    <style>
        body {
            font-family: sans-serif;
            background: #f1f5f9;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        .reset-box {
            background: #fff;
            padding: 30px 20px;
            border-radius: 12px;
            width: 100%;
            max-width: 400px;
            box-shadow: 0 0 10px rgba(0,0,0,0.08);
        }
        h2 {
            text-align: center;
            font-size: 1.5rem;
            margin-bottom: 20px;
        }
        input, button {
            width: 100%;
            padding: 12px;
            margin-top: 12px;
            font-size: 1rem;
            border-radius: 8px;
        }
        input {
            border: 1px solid #cbd5e1;
            background-color: #f8fafc;
        }
        button {
            background-color: #2563eb;
            color: white;
            border: none;
            font-weight: bold;
        }
        .msg {
            text-align: center;
            padding: 10px;
            margin-bottom: 10px;
            border-radius: 6px;
        }
        .success { background: #d1fae5; color: #065f46; }
        .error { background: #fee2e2; color: #991b1b; }
        .link {
            text-align: center;
            margin-top: 15px;
        }
    </style>
</head>
<body>
<div class="reset-box">
    <h2>Reset Password</h2>
    <?php if (isset($error)) echo "<div class='msg error'>$error</div>"; ?>
    <?php if (isset($success)) echo "<div class='msg success'>$success</div>"; ?>
    <form method="POST">
        <input type="text" name="name" placeholder="Driver Name" required>
        <input type="password" name="new_password" placeholder="New Password" required>
        <button type="submit">Reset</button>
    </form>
    <div class="link">
        <a href="driver_login.php">Back to login</a>
    </div>
</div>
</body>
</html>
