<?php
session_start();
include_once('../../includes/db.php'); // ✅ Correct path now

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name']);
    $password = trim($_POST['password']);

    $stmt = $conn->prepare("SELECT id FROM drivers WHERE name = ?");
    $stmt->bind_param("s", $name);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows > 0) {
        $error = "Driver name already exists.";
    } else {
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);
        $stmt = $conn->prepare("INSERT INTO drivers (name, password) VALUES (?, ?)");
        $stmt->bind_param("ss", $name, $hashed_password);
        if ($stmt->execute()) {
            $_SESSION['driver_logged_in'] = true;
            $_SESSION['driver_name'] = $name;
            $_SESSION['driver_id'] = $stmt->insert_id;
            header("Location: driver_orders.php");
            exit;
        } else {
            $error = "Registration failed.";
        }
    }
    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Driver Registration</title>
    <style>
        * { box-sizing: border-box; }
        body {
            font-family: sans-serif;
            background: #f1f5f9;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        .register-box {
            background: #fff;
            padding: 30px 20px;
            border-radius: 12px;
            width: 100%;
            max-width: 400px;
            box-shadow: 0 0 10px rgba(0,0,0,0.08);
        }
        h2 {
            text-align: center;
            font-size: 1.5rem;
            margin-bottom: 20px;
        }
        input, button {
            width: 100%;
            padding: 12px;
            margin-top: 12px;
            font-size: 1rem;
            border-radius: 8px;
        }
        input {
            border: 1px solid #cbd5e1;
            background-color: #f8fafc;
        }
        button {
            background-color: #2563eb;
            color: white;
            border: none;
            font-weight: bold;
        }
        .error {
            background-color: #fee2e2;
            color: #b91c1c;
            padding: 10px;
            border-radius: 6px;
            text-align: center;
            margin-bottom: 15px;
        }
        .link {
            margin-top: 16px;
            text-align: center;
        }
    </style>
</head>
<body>
<div class="register-box">
    <h2>Register</h2>
    <?php if (isset($error)) echo "<div class='error'>$error</div>"; ?>
    <form method="POST">
        <input type="text" name="name" placeholder="Driver Name" required>
        <input type="password" name="password" placeholder="Create Password" required>
        <button type="submit">Register</button>
    </form>
    <div class="link">
        Already registered? <a href="driver_login.php">Login here</a>
    </div>
</div>
</body>
</html>
