<?php
session_start();
include_once('../../includes/db.php');

if (!isset($_SESSION['driver_logged_in'])) {
    header("Location: driver_login.php");
    exit;
}

$driver_id = $_SESSION['driver_id'];

$orders = fetchAll("
    SELECT o.*, u.name AS user_name, u.phone 
    FROM orders o 
    JOIN users u ON o.user_id = u.id 
    WHERE o.driver_id = $driver_id
    ORDER BY o.created_at DESC
");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Driver Orders</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f1f5f9;
            padding: 20px;
            font-family: sans-serif;
        }
        .card {
            border-radius: 1rem;
        }
        .badge {
            text-transform: capitalize;
        }
        .mobile-table {
            font-size: 0.9rem;
        }
        @media (max-width: 767px) {
            h5 {
                font-size: 1.1rem;
            }
            .mobile-table th, .mobile-table td {
                white-space: nowrap;
            }
            .logout-btn {
                font-size: 0.875rem;
            }
        }
    </style>
</head>
<body>
<div class="container">

    <?php if (isset($_GET['success'])): ?>
        <div class="alert alert-success"><?= htmlspecialchars($_GET['success']) ?></div>
    <?php elseif (isset($_GET['error'])): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($_GET['error']) ?></div>
    <?php endif; ?>

    <div class="d-flex justify-content-between align-items-center mb-3 flex-wrap">
        <div class="fw-semibold mb-2">
            Logged in as <strong><?= htmlspecialchars($_SESSION['driver_name']) ?></strong>
        </div>
        <a href="driver_logout.php" class="btn btn-sm btn-outline-danger logout-btn">Logout</a>
    </div>

    <div class="card shadow-sm border-0">
        <div class="card-header bg-primary text-white rounded-top">
            <h5 class="mb-0">🚚 My Assigned Orders</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover align-middle bg-white mt-2 mobile-table">
                    <thead class="table-light">
                        <tr>
                            <th>Order ID</th>
                            <th>User</th>
                            <th>Phone</th>
                            <th>Shipping Address</th>
                            <th>Status</th>
                            <th>Created</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($orders as $order): ?>
                            <tr>
                                <td>#<?= $order['id'] ?></td>
                                <td><?= htmlspecialchars($order['user_name']) ?></td>
                                <td><?= htmlspecialchars($order['phone']) ?></td>
                                <td>
                                    <?= nl2br(htmlspecialchars($order['address'])) ?><br>
                                    <small class="text-muted">📍 <?= htmlspecialchars($order['location']) ?></small>
                                </td>
                                <td>
                                    <span class="badge text-bg-<?=
                                        $order['status'] === 'placed' ? 'warning' :
                                        ($order['status'] === 'shipped' ? 'info' : 'success')
                                    ?>">
                                        <?= ucfirst($order['status']) ?>
                                    </span>

                                    <?php if ($order['status'] !== 'delivered'): ?>
                                        <form method="POST" action="driver_update_status.php" class="mt-2 d-flex">
                                            <input type="hidden" name="order_id" value="<?= $order['id'] ?>">
                                            <select name="new_status" class="form-select form-select-sm me-2" required>
                                                <option value="shipped" <?= $order['status'] === 'shipped' ? 'selected' : '' ?>>Shipped</option>
                                                <option value="delivered" <?= $order['status'] === 'delivered' ? 'selected' : '' ?>>Delivered</option>
                                            </select>
                                            <button type="submit" class="btn btn-sm btn-success">Update</button>
                                        </form>
                                    <?php endif; ?>
                                </td>
                                <td><?= date('d M Y - h:i A', strtotime($order['created_at'])) ?></td>
                            </tr>
                        <?php endforeach; ?>
                        <?php if (empty($orders)): ?>
                            <tr>
                                <td colspan="6" class="text-center">No orders assigned to you.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
</body>
</html>
