<?php
session_start();
include_once('../../includes/db.php'); // ✅ Correct path now

$name = '';
$remember_me_checked = false;

if (!isset($_SESSION['driver_logged_in']) && isset($_COOKIE['driver_login'])) {
    list($cookie_name, $cookie_id) = explode(':', $_COOKIE['driver_login']);

    $stmt = $conn->prepare("SELECT id, name FROM drivers WHERE id = ? AND name = ?");
    $stmt->bind_param("is", $cookie_id, $cookie_name);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 1) {
        $driver = $result->fetch_assoc();
        $_SESSION['driver_logged_in'] = true;
        $_SESSION['driver_name'] = $driver['name'];
        $_SESSION['driver_id'] = $driver['id'];
        header("Location: driver_orders.php");
        exit;
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name']);
    $password = trim($_POST['password']);
    $remember_me_checked = isset($_POST['remember_me']);

    $stmt = $conn->prepare("SELECT id, name, password FROM drivers WHERE name = ?");
    $stmt->bind_param("s", $name);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 1) {
        $driver = $result->fetch_assoc();

        if (password_verify($password, $driver['password'])) {
            $_SESSION['driver_logged_in'] = true;
            $_SESSION['driver_name'] = $driver['name'];
            $_SESSION['driver_id'] = $driver['id'];

            if ($remember_me_checked) {
                $cookie_value = "{$driver['name']}:{$driver['id']}";
                setcookie("driver_login", $cookie_value, time() + (86400 * 30), "/");
            }

            header("Location: driver_orders.php");
            exit;
        }
    }

    $error = "Invalid name or password.";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Driver Login - PrintShop</title>
    <style>
        * { box-sizing: border-box; }
        body {
            margin: 0;
            padding: 0;
            font-family: 'Arial', sans-serif;
            background-color: #f1f5f9;
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100vh;
        }
        .login-box {
            background: #fff;
            padding: 25px 20px;
            border-radius: 12px;
            width: 100%;
            max-width: 400px;
            box-shadow: 0 0 12px rgba(0, 0, 0, 0.08);
        }
        h2 {
            text-align: center;
            margin-bottom: 25px;
            font-size: 1.5rem;
            color: #111827;
        }
        input, button {
            width: 100%;
            padding: 12px;
            margin-top: 12px;
            border-radius: 8px;
            font-size: 1rem;
        }
        input {
            border: 1px solid #cbd5e1;
            background-color: #f9fafb;
        }
        button {
            background-color: #2563eb;
            color: white;
            border: none;
            font-weight: bold;
        }
        .checkbox-container {
            display: flex;
            align-items: center;
            margin-top: 12px;
        }
        .checkbox-container input {
            margin-right: 8px;
            width: auto;
        }
        .toggle-password {
            position: absolute;
            right: 16px;
            top: 50%;
            transform: translateY(-50%);
            font-size: 0.9em;
            cursor: pointer;
        }
        .input-wrapper {
            position: relative;
        }
        .error {
            background-color: #fee2e2;
            color: #991b1b;
            padding: 10px;
            border-radius: 8px;
            text-align: center;
            margin-bottom: 15px;
            font-size: 0.95em;
        }
        .link {
            margin-top: 18px;
            text-align: center;
            font-size: 0.95em;
        }
        a {
            color: #2563eb;
            text-decoration: none;
        }
    </style>
</head>
<body>
<div class="login-box">
    <h2>Driver Login</h2>
    <?php if (isset($error)) echo "<div class='error'>$error</div>"; ?>
    <form method="POST">
        <input type="text" name="name" placeholder="Driver Name" value="<?= htmlspecialchars($name) ?>" required>

        <div class="input-wrapper">
            <input type="password" name="password" placeholder="Password" id="passwordInput" required>
            <span class="toggle-password" onclick="togglePassword()">👁️</span>
        </div>

        <div class="checkbox-container">
            <input type="checkbox" name="remember_me" <?= $remember_me_checked ? 'checked' : '' ?>>
            <label for="remember_me">Remember Me</label>
        </div>

        <button type="submit">Login</button>
    </form>

    <div class="link">
        First time? <a href="driver_register.php">Create an account</a><br>
        <a href="driver_reset_password.php">Forgot password?</a>
    </div>
</div>

<script>
    function togglePassword() {
        const pwd = document.getElementById('passwordInput');
        pwd.type = pwd.type === 'password' ? 'text' : 'password';
    }
</script>
</body>
</html>
