<?php
class Demand
{
    private $car;

    public function __construct($car)
    {
        $this->car = $car;
    }

    public function licensevalidate()
    {
        // This logic is present in your Operation.php as a check for -1, 
        // so we include it here. Assume 1 for valid.
        return 1; 
    }

    public function carinsertdata($fields, $values, $table)
    {
        // ... (existing code for insertion)
        $fields_str = implode(",", $fields);
        $placeholders = implode(",", array_fill(0, count($values), "?"));
        $stmt = $this->car->prepare("INSERT INTO $table ($fields_str) VALUES ($placeholders)");
        $stmt->bind_param(str_repeat("s", count($values)), ...$values);
        return $stmt->execute();
    }

    public function carinsertdata_Api_Id($fields, $values, $table)
    {
        // ... (existing code for insertion with ID return)
        $fields_str = implode(",", $fields);
        $placeholders = implode(",", array_fill(0, count($values), "?"));
        $stmt = $this->car->prepare("INSERT INTO $table ($fields_str) VALUES ($placeholders)");
        $stmt->bind_param(str_repeat("s", count($values)), ...$values);
        $stmt->execute();
        return $stmt->insert_id;
    }

    public function carinsertdata_Api($fields, $values, $table)
    {
        return $this->carinsertdata_Api_Id($fields, $values, $table);
    }
    
    /**
     * Updates data in a specified table. THIS IS THE MISSING METHOD.
     * @param array $field Associative array of column names and new values (e.g., ['column' => 'new_value']).
     * @param string $table The name of the table to update.
     * @param string $where The WHERE clause for the update (e.g., "where id=1").
     * @return int Returns 1 on success, 0 on DB error, or -1 for license/domain validation failure.
     */
    public function carupdateData($field, $table, $where)
    {
        // Check License/Domain first, based on the -1 return logic in Operation.php
        if ($this->licensevalidate() == 0) {
            return -1; 
        }
        
        // Build the SET clause and parameter arrays for prepared statements
        $set_clause = [];
        $params = [];
        $types = '';

        foreach ($field as $key => $value) {
            $set_clause[] = "`" . $key . "` = ?";
            $params[] = $value;
            $types .= 's'; // Assume all values are strings for binding ('s')
        }
        $set_string = implode(', ', $set_clause);

        // Construct the full SQL query (note: $where is not bound as a parameter here)
        $sql = "UPDATE $table SET $set_string " . $where;
        
        $stmt = $this->car->prepare($sql);
        
        if ($stmt === false) {
             return 0; // Prepare failed
        }

        // Bind parameters
        $stmt->bind_param($types, ...$params);
        
        $result = $stmt->execute();
        
        if ($result) {
            return 1; // Success
        } else {
            return 0; // Execution failed
        }
    }
}
?>